/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models;

import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialView;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

public class CustomBlendModeModel
extends ForwardingBakedModel {
    private final RenderContext.QuadTransform transform;

    public CustomBlendModeModel(class_1087 owner, BlendMode blendMode) {
        this.wrapped = owner;
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        MaterialFinder finder = renderer == null ? null : renderer.materialFinder();
        this.transform = finder == null ? quad -> true : quad -> {
            RenderMaterial newMaterial = finder.copyFrom((MaterialView)quad.material()).blendMode(blendMode).find();
            quad.material(newMaterial);
            return true;
        };
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        context.pushTransform(this.transform);
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        context.pushTransform(this.transform);
        super.emitItemQuads(stack, randomSupplier, context);
        context.popTransform();
    }
}

